(function() {
  // Owner: Rafa Dorado
  // Date: 1/10/13
  // Time: 11:25 AM
  define(['Backbone', 'json2xml'], function(Backbone) {
    var RequestModel;
    return RequestModel = class RequestModel extends Backbone.Model {
      initialize() {
        //#console.log "Model XMLRequestModel initialized"
        this.urlXML = window.baseUrl + 'api/json';
        this.response = '';
        return this.error = '';
      }

      defaults() {
        return {
          'JLogin': {
            'Body': {
              'Request': 'CreateSession',
              'userName': '',
              'key': '',
              'appID': '1207',
              'appVersion': '5',
              'holidaysTimeStamp': "(null)",
              'profilePropertiesTimeStamp': "(null)",
              'getUsersEventsForCurrentWeek': '(null)',
              'getUsersNotDoneTimereports': '1',
              'getUsersTodos': '1',
              'getUsersNotificationsNotReadCount': '1',
              'APNSDeviceToken': '',
              'APNSDeviceIsEnabled': '0',
              'timezone': ''
            }
          },
          'JDisconnect': {
            'Body': {
              'sessionID': '',
              'Request': 'Disconnect'
            }
          },
          'JGetNotifications': {
            'Body': {
              'sessionID': '',
              'Request': 'GetNotifications'
            }
          },
          'JGetBookingStructures': {
            'Body': {
              'sessionID': '',
              'Request': 'GetBookingStructures',
              'cacheTimeStamp': '(null)'
            }
          },
          'JGetEvents': {
            'Body': {
              'sessionID': '',
              'Request': 'GetEvents',
              'objectType': '',
              'objectID': '',
              'day': ''
            }
          },
          'JSetShiftAvailability': {
            'Body': {
              'sessionID': '',
              'Request': 'SetShiftAvailability',
              'eventID': '',
              'userIsAvailable': ''
            }
          },
          'JGetRecentTimereports': {
            'Body': {
              'sessionID': '',
              'Request': 'GetRecentTimereports'
            }
          },
          'JGetNotDoneTimereports': {
            'Body': {
              'sessionID': '',
              'Request': 'GetNotDoneTimereports'
            }
          },
          'JSetBookingAcceptStatus': {
            'Body': {
              'sessionID': '',
              'Request': 'SetBookingAcceptStatus',
              'eventID': '',
              'bookingLineID': '',
              'acceptStatus': ''
            }
          },
          'JSetDeclinedNote': {
            'Body': {
              'sessionID': '',
              'Request': 'SetDeclinedNote',
              'eventID': '',
              'bookingLineID': '',
              'declinedNote': ''
            }
          },
          'JSetBookingNote': {
            'Body': {
              'sessionID': '',
              'Request': 'SetBookingNote',
              'bookingID': '',
              'note': ''
            }
          },
          'JGetBooking': {
            'Body': {
              'sessionID': '',
              'Request': 'GetBooking',
              'bookingID': '',
              'bookingLineID': '',
              'day': ''
            }
          },
          'JGetContacts': {
            'Body': {
              'sessionID': '',
              'Request': 'GetContacts',
              'cacheTimeStamp': ''
            }
          },
          'JGetContact': {
            'Body': {
              'sessionID': '',
              'Request': 'GetContact',
              'contactID': ''
            }
          },
          'JCommitContact': {
            'Body': {
              'sessionID': '',
              'Request': 'CommitObject',
              'Object': {
                'Contact': {
                  'firstName': '',
                  'lastName': '',
                  'type': '',
                  'title': '',
                  'email': '',
                  'www': '',
                  'note': '',
                  'category': '',
                  'contactID': '',
                  'companyName': '',
                  'companyID': '',
                  'address': '',
                  'phoneWork': '',
                  'phoneHome': '',
                  'phoneDirect': '',
                  'phoneMobile': '',
                  'fax': '',
                  'other': ''
                }
              }
            }
          },
          'JDeleteContact': {
            'Body': {
              'sessionID': '',
              'Request': 'DeleteContact',
              'contactID': ''
            }
          },
          'JGetCompany': {
            'Body': {
              'sessionID': '',
              'Request': 'GetCompany',
              'companyID': '',
              'includeContacts': ''
            }
          },
          'JGetCompanies': {
            'Body': {
              'sessionID': '',
              'Request': 'GetCompanies',
              'compressed': '1'
            }
          },
          'JGetTimereport': {
            'Body': {
              'sessionID': '',
              'Request': 'GetTimereport',
              'bookingID': '',
              'day': ''
            }
          },
          'JCommitTimereport': {
            'Body': {
              'sessionID': '',
              'Request': 'CommitObject',
              'Object': {
                'Timereport': {
                  'dayNote': '',
                  'bookingID': '',
                  'adhocProjectID': '',
                  'day': '',
                  'isAdhoc': '',
                  'TimeBreak': {
                    'header': '',
                    'note': '',
                    'timeIn': '',
                    timeBreakID: '',
                    'timeOut': ''
                  },
                  'Involved': {
                    'objectID': '',
                    'type': '',
                    'timeunitQuantityReported': '',
                    'activityID': '',
                    'noteReported': '',
                    'involvedID': '',
                    'timeInReported': '',
                    'timeOutReported': '',
                    'classID': '',
                    'outTimeGoesIntoNextDay': ''
                  }
                }
              }
            }
          },
          'JValidateTravelExpenseSheet': {
            'Body': {
              'sessionID': '',
              'Request': 'ValidateTravelExpenseSheet',
              'TravelExpenseSheet': {
                'travelExpenseSheetID': '',
                'startDateAndTime': '',
                'stopDateAndTime': '',
                'note': '',
                'destination': '',
                'breakfastDays': '',
                'lunchDays': '',
                'dinnerDays': '',
                'abroad': '',
                'usePerDiem': '',
                'Drive': {},
                'CashAdvance': {},
                'Expense': {}
              }
            }
          },
          'JCommitBooking': {
            'Body': {
              'sessionID': '',
              'Request': 'CommitObject',
              'Object': {
                'Booking': {
                  'name': '',
                  'note': '',
                  'parentType': '',
                  'bookingID': '',
                  'day': '',
                  'occursOnDay': '',
                  'timeIn': '',
                  'timeOut': ''
                }
              }
            }
          },
          'JDeleteBooking': {
            'Body': {
              'sessionID': '',
              'Request': 'DeleteBooking',
              'bookingID': '',
              'bookingLineID': 'bookingLineID',
              'day': ''
            }
          },
          'JGetPdfReport': {
            'Body': {
              'sessionID': '',
              'Request': 'GetReport',
              'report': '',
              'type': 'user',
              'objectID': '',
              'year': '',
              'month': '',
              'clientType': 'android'
            }
          },
          'JGetObjectsAndStructures': {
            'Body': {
              'sessionID': '',
              'Request': 'GetObjectsAndStructures',
              'cacheTimeStamp': '(null)',
              'includeProjects': '',
              'usageContext': '',
              'shortNodeNames': '1'
            }
          },
          //'JGetObjectDetail' :'Body':{'sessionID':'','Request':'GetObjectDetail','objectID':'','objectType':'','objectViewName':''}
          'JGetFavorites': {
            'Body': {
              'sessionID': '',
              'Request': 'GetFavorites',
              'cacheTimeStamp': '(null)'
            }
          },
          'JAddFavorite': {
            'Body': {
              'sessionID': '',
              'Request': 'AddFavorite',
              'objectID': '',
              'objectType': '',
              groupName: ''
            }
          },
          'JRemoveFavorite': {
            'Body': {
              'sessionID': '',
              'Request': 'RemoveFavorite',
              'objectID': '',
              groupName: ''
            }
          },
          'JGetProjects': {
            'Body': {
              'sessionID': '',
              'Request': 'GetProjects'
            }
          },
          'JGetRecentProjectIDS': {
            'Body': {
              'sessionID': '',
              'Request': 'GetRecentProjectIDS'
            }
          },
          'JGetProjectDetails': {
            'Body': {
              'sessionID': '',
              'Request': 'GetProjectDetails',
              projectID: ''
            }
          },
          'JGetBookingProject': {
            'Body': {
              'sessionID': '',
              'Request': 'GetBookingProject',
              projectID: ''
            }
          },
          'JCommitProject': {
            'Body': {
              'sessionID': '',
              'Request': 'CommitObject',
              'Object': {
                'Project': {
                  'name': '',
                  'id': '',
                  'contactID': '',
                  'contactName': '',
                  'contactCompanyName': '',
                  'note': ''
                }
              }
            }
          },
          'JGetTodoStructures': {
            'Body': {
              'sessionID': '',
              'Request': 'GetTodoStructures'
            }
          },
          'JGetTodos': {
            'Body': {
              'sessionID': '',
              'Request': 'GetTodos',
              'includeRecent': ''
            }
          },
          'JGetTodo': {
            'Body': {
              'sessionID': '',
              'Request': 'GetTodo',
              'todoID': '',
              'type': ''
            }
          },
          'JSetTodoIsDone': {
            'Body': {
              'sessionID': '',
              'Request': 'SetTodoIsDone',
              'todoID': '',
              'isDone': ''
            }
          },
          'JSetTodoIsDeclined': {
            'Body': {
              'sessionID': '',
              'Request': 'SetTodoIsDeclined',
              'todoID': '',
              'isDeclined': ''
            }
          },
          'JSetTodoReplyNote': {
            'Body': {
              'sessionID': '',
              'Request': 'SetTodoReplyNote',
              'todoID': '',
              'replyNote': ''
            }
          },
          'JCommitTodo': {
            'Body': {
              'sessionID': '',
              'Request': 'CommitObject',
              'Object': {
                'Todo': {
                  'todoID': '',
                  'note': '',
                  'isDone': '',
                  'title': '',
                  'priority': '',
                  'type': '',
                  'declined': '',
                  'assignedToID': '',
                  'linkedToID': '',
                  'projectID': '',
                  'replyNote': '',
                  'hide': '0'
                }
              }
            }
          },
          'JLoginExternal': {
            'Body': {
              'Request': 'OIDCGetURL',
              'appID': '1207',
              'appVersion': '5'
            }
          },
          'JLoginAppleConnect': {
            'Body': {
              'Request': 'OIDCGetURL',
              'appID': '1207',
              'appVersion': '5'
            }
          },
          //PASSWORD CHANGE
          'JChangePassword': {
            'Body': {
              'sessionID': '',
              'Request': 'ChangePassword',
              'oldPassword': '',
              'newPassword': ''
            }
          },
          'JChangeExpiredPassword': {
            'Body': {
              'Request': 'ChangeExpiredPassword',
              'oldPassword': '',
              'newPassword': ''
            }
          },
          
          //SERVER INFO
          'JGetServerInfo': {
            'Body': {
              'Request': 'GetServerInfo',
              'appID': '1207',
              'appVersion': '5'
            }
          }
        };
      }

      __setNodeValue(reqJSON, node, value) {
        reqJSON['Body'][node] = value;
        return reqJSON;
      }

      __setNodeWithParent(reqJSON, parent, node, value) {
        reqJSON['Body'][parent][node] = value;
        return reqJSON;
      }

      __setNodeValueWithObjectParent(reqJSON, parent, node, value) {
        if (value === void 0 || value === null) {
          value = "";
        }
        reqJSON['Body']['Object'][parent][node] = value;
        return reqJSON;
      }

      __getXML(json) {
        return json2xml.convert(json);
      }

      __send_server_xmlrequest(xmlRaw) {
        var that, xml;
        that = this;
        //#PARANOID UNDEFINED ID CLEANING, THEORICALLY WE NEVER HAVE ANY UNDEFINED AT THIS STAGE, BUT JUST IN CASE
        xml = xmlRaw.replace("undefined", "");
        return $.ajax({
          url: that.urlXML,
          data: xml,
          dataType: 'json',
          contentType: "application/json; charset=utf-8",
          type: 'POST',
          success: function(data) {
            return this.response = data;
          },
          error: function(e, x, type) {
            return this.error = e;
          }
        });
      }

      __send_server_xmlrequest_sync(xmlRaw) {
        var that, xml;
        that = this;
        xml = xmlRaw.replace("undefined", "");
        return $.ajax({
          url: that.urlXML,
          data: xml,
          dataType: 'json',
          async: false,
          contentType: "application/json; charset=utf-8",
          type: 'POST',
          success: function(data) {
            return this.response = data;
          },
          error: function(e, x, type) {
            return this.error = e;
          }
        });
      }

    };
  });

}).call(this);
